//----------------------------------------------------------
// Copyright (C) Microsoft Corporation. All rights reserved.
//----------------------------------------------------------
var __extends=this.__extends||function(b,c){function a(){this.constructor=b}a.prototype=c.prototype;b.prototype=new a};define(["require","exports","Presentation/Scripts/TFS/TFS","Presentation/Scripts/TFS/TFS.Core","Diagnostics/Scripts/TFS.Diag","Presentation/Scripts/TFS/TFS.UI.Controls","Presentation/Scripts/TFS/TFS.UI.Controls.Menus","Presentation/TestScripts/Resources/TFS.Resources.Presentation","Presentation/Scripts/TFS/TFS.UI.Controls.Common","Presentation/Scripts/TFS/TFS.Host","Presentation/Scripts/TFS/TFS.UI.Controls.Data","Presentation/Scripts/TFS/TFS.Core.Utils","Presentation/Scripts/TFS/TFS.UI"],function(G,i,F,C,E,x,u,w,t,y,D,v,z){var n=F,f=C,a=E,h=x,q=u,B=w,o=t,j=y,d=D,A=v,e=z,m=a.log,l=a.LogVerbosity.Verbose,c=f.delegate,b=e.domElem,p;function s(a,f,e,d,c){var b;while(a<f){c[a]=e;b=Math.abs(d[a++])+a;if(b>a){s(a,b,e+1,d,c);a=b}}}var g=function(i){__extends(g,i);function g(a){i.call(this,a);this._rows={}}g._typeName="tfs.grid";g.MAX_COPY_SIZE=1e3;g.PAYLOAD_SIZE=200;g.EVENT_ROW_UPDATED="rowupdated";g.EVENT_SELECTED_INDEX_CHANGED="selectedIndexChanged";g.prototype.initializeOptions=function(a){i.prototype.initializeOptions.call(this,$.extend({autoSort:true,payloadSize:g.PAYLOAD_SIZE,extendViewportBy:3,gutter:{contextMenu:false,icon:false,checkbox:false},header:true,allowMoveColumns:true,draggable:null,droppable:null,asyncInit:true,sharedMeasurements:true,coreCssClass:"grid"},a))};g.prototype.getSelectionCount=function(){return this._selectionCount};g.prototype._enhance=function(a){i.prototype._enhance.call(this,a);this._buildDom()};g.prototype.initialize=function(){i.prototype.initialize.call(this);this._contentSize={width:300,height:400};this._takeMeasurements();if(this._options.asyncInit)f.delay(this,10,function(){this._attachEvents()});else this._attachEvents();this.initializeDataSource();a.logTracePoint("Grid.initialize.complete")};g.prototype.getDraggingRowInfo=function(){return this._draggingRowInfo};g.prototype._getDragOverRows=function(){return this._ddRowOverStatus};g.prototype._resetRowAcceptStatus=function(){this._ddRowAcceptStatus={}};g.prototype._rowDropTryActivate=function(a,c,e,d){var b=this._ddRowAcceptStatus[a.dataIndex];if(typeof b==="undefined"){this._ddRowAcceptStatus[a.dataIndex]=b=this._rowDropAccept(a,c,e,d);b&&this._rowDropActivate(a,c,e,d)}return b};g.prototype._rowIntersect=function(d,c){var b=this._rows[c.dataIndex],a;if(b){a=b.row;return $.ui.intersect(d,{offset:a.offset(),proportions:{width:a[0].offsetWidth,height:a[0].offsetHeight}},this._droppable.tolerance)}return false};g.prototype.initializeDataSource=function(){var a;if(this._resetScroll){this._ignoreScroll=true;try{a=this._canvas[0];a.scrollTop=0;a.scrollLeft=0;this._scrollLeft=0;this._scrollTop=0;this._resetScroll=false}finally{this._ignoreScroll=false}}this.setDataSource(this._options.source,this._options.expandStates,this._options.columns,this._options.sortOrder);if(this._expandedCount>0)if(this._options.keepSelection&&this._selectedIndex>=0)this._selectRow(Math.min(this._selectedIndex,this._expandedCount-1));else this._selectRow(this._options.initialSelection!==false?0:-1);else this.setSelectedRowIndex(-1)};g.prototype.setDataSource=function(m,e,h,g,l){var c,d,i,b,j=this;this._dataSource=m||[];this._count=i=this._dataSource.length;if(e){this._expandStates=e;this._indentLevels=[];s(0,i,1,e,this._indentLevels)}else{this._indentLevels=null;this._expandStates=null}this._expandedCount=i;this._updateRanges();this._columns=[];if(h)for(c=0,d=h.length;c<d;c++){b=h[c];b.index=typeof b.index!=="undefined"?b.index:c;b.canSortBy=b.canSortBy!==false;b.canMove=b.canMove!==false;b.width=typeof b.width!=="undefined"?b.width:100;b.getCellContents=b.getCellContents||this._drawCell;b.getHeaderCellContents=b.getHeaderCellContents||this._drawHeaderCellValue;b.getColumnValue=b.getColumnValue||this.getColumnValue;this._columns.push(b)}this._sortOrder=[];if(g)for(c=0,d=g.length;c<d;c++){b=g[c];if(b.order!=="desc")b.order="asc";this._sortOrder.push(b)}this._clearSelection();this._determineIndentIndex();function k(){if(!j.isDisposed()){j.layout();j._ensureSelectedIndex(l)}else a.logWarning("Layout called (in setDataSource) after grid was disposed.")}if(this._options.asyncInit)f.delay(this,0,k);else k()};g.prototype.getRowInfo=function(b){a.assertParamIsNumber(b,"dataIndex");return this._rows[b]};g.prototype.getRowData=function(b){a.assertParamIsNumber(b,"dataIndex");return this._dataSource[b]};g.prototype.getColumns=function(){return this._columns||[]};g.prototype.getSortOrder=function(){return this._sortOrder||[]};g.prototype.setColumnOptions=function(d,e){a.assertParamIsString(d,"columnName");a.assertParamIsObject(e,"options");var b,f,c=this._columns;for(b=0,f=c.length;b<f;b++)if(c[b].name===d){c[b]=$.extend(c[b],e);break}};g.prototype._getDataIndex=function(a){var c,f,d=-1,e=this._visibleRange,b;if(a<0)return-1;for(c=0,f=e.length;c<f;c++){b=e[c];d+=b[1]-b[0]+1;if(a<=d)return b[1]-d+a}return a};g.prototype._getRowIndex=function(c){var b,f,d=0,e=this._visibleRange,a;for(b=0,f=e.length;b<f;b++){a=e[b];if(c>=a[0]){if(c<=a[1])return d+c-a[0]}else break;d+=a[1]-a[0]+1}return-Math.max(0,d-1)};g.prototype.expandNode=function(a){var b,c;if(this._expandStates){b=this._expandStates[a];if(b<0){this._expandStates[a]=-b;this._updateRanges();c=this._rows[a];if(c)c.dirty=true}}};g.prototype.collapseNode=function(a){var b,c;if(this._expandStates){b=this._expandStates[a];if(b>0){this._expandStates[a]=-b;this._updateRanges();c=this._rows[a];if(c)c.dirty=true}}};g.prototype.expandAllNodes=function(){var a=0,g=this._count,c=this._expandStates,d,b=false,e,f=this._rows;if(c){while(a<g){d=c[a];if(d<0){c[a]=-d;b=true;e=f[a];if(e)e.dirty=true}a++}b&&this._updateRanges()}return b};g.prototype.collapseAllNodes=function(){var a=0,g=this._count,c=this._expandStates,d,b=false,e,f=this._rows;if(c){while(a<g){d=c[a];if(d>0){c[a]=-d;b=true;e=f[a];if(e)e.dirty=true}a++}b&&this._updateRanges()}return b};g.prototype.expandAll=function(){a.logTracePoint("Grid.expandAll.start");this._updateExpansionStateAndRedraw.call(this,this.expandAllNodes);a.logTracePoint("Grid.expandAll.complete")};g.prototype.collapseAll=function(){a.logTracePoint("Grid.collapseAll.start");this._updateExpansionStateAndRedraw.call(this,this.collapseAllNodes);a.logTracePoint("Grid.collapseAll.complete")};g.prototype.tryToggle=function(c,e){var d,a,b;if(!this._expandStates||this._selectedIndex<0||this._expandedCount<=0)return false;a=this._getDataIndex(this._selectedIndex);d=this._rows[a];if(!d)return false;if(e){if(c){if(!this.expandAllNodes())return false}else if(!this.collapseAllNodes())return false;this._clearSelection();this._addSelection(Math.abs(this._getRowIndex(a)));this._layoutContentSpacer();this._redraw();return true}else{b=this._expandStates[a];if(b!==0){if(c)if(b<0)this.expandNode(a);else return false;else if(b>0)this.collapseNode(a);else return false;this._clearSelection();this._addSelection(this._getRowIndex(a));this._layoutContentSpacer();this._redraw();return true}}return false};g.prototype._getVisibleRowIndices=function(){var b=this._scrollTop,d=b+this._canvasHeight,a=this._expandedCount-1,c=this._rowHeight;return{first:Math.min(a,Math.max(0,Math.ceil(b/c))),last:Math.min(a,Math.floor(d/c)-1)}};g.prototype._getRowIntoView=function(b,f){var d,a,e,c;if(f){this._canvas[0].scrollTop=Math.max(0,Math.min(b||0,this._expandedCount-1))*this._rowHeight;return true}d=this._getVisibleRowIndices();a=d.first;e=d.last;c=e-a;if(b<a||b>e){if(this._selectedIndex>a)a=Math.max(b-c,0);else a=Math.max(0,Math.min(b+c,this._expandedCount-1)-c);this._canvas[0].scrollTop=a*this._rowHeight;return true}return false};g.prototype.getSelectedRowIntoView=function(a){return this._getRowIntoView(this._selectedIndex,a)};g.prototype.cacheRows=function(){};g.prototype._drawRows=function(p,u){var i,t,m,f=this._rows,a,e,c,q={},r=this._expandStates,o=0,w=this._indentLevels,s=0,g=this._gutter,v=this._canvas[0],n,h,k,d,l,j;l=document.createDocumentFragment();if(g){n=this._gutter[0];j=document.createDocumentFragment()}this._rows=q;for(i=0,t=p.length;i<t;i++){m=p[i];e=m[0];c=m[1];a=f[c];if(a){d=a.rowIndex!==e;if(d)a.rowIndex=e;else{d=a.dirty;delete a.dirty}if(u)d=true;delete f[c]}else{d=true;a={rowIndex:e,dataIndex:c};h=b("div","grid-row grid-row-normal");h.id="row_"+this._getId()+"_"+e;l.appendChild(h);a.row=$(h).data("grid-row-info",a);if(g){k=b("div","grid-gutter-row grid-gutter-row-normal");j.appendChild(k);a.gutterRow=$(k).data("grid-row-info",a)}}q[c]=a;if(d){if(r){o=r[c];s=w[c]}this._updateRow(a,e,c,o,s)}}for(c in f)if(f.hasOwnProperty(c)){a=f[c];a.row.remove();g&&a.gutterRow.remove()}v.appendChild(l);g&&n.appendChild(j)};g.prototype.updateRow=function(b,a){var c,d=0,e=0;if(typeof a==="undefined"||a<0)a=this._getDataIndex(b);else if(typeof b==="undefined"||b<0)b=this._getRowIndex(a);c=this._rows[a];if(c){if(this._expandStates){d=this._expandStates[a];e=this._indentLevels[a]}this._updateRow(c,b,a,d,e)}};g.prototype._updateRow=function(h,k,f,o,s){var t,d,a,q,c,n,v,i,m,u,w,j,x,r,l,p;w=this._indentIndex;if(this._gutter){a=this._options.gutter;q=h.gutterRow;c=q[0];c.style.top=k*this._rowHeight+"px";c.style.left="0px";c.style.width=this._gutterWidth+"px";c.style.height=this._rowHeight+"px";if(a.contextMenu){n=b("div","grid-gutter-cell grid-gutter-drop grid-gutter-menu");this._options.source&&this._options.source[f]&&this._options.source[f].noContextMenu&&$(n).removeClass("grid-gutter-drop");q.append(n)}if(a.checkbox){u=$(b("input","checkbox "+(a.checkbox.cssClass||""))).attr("type","checkbox");m=b("div","grid-gutter-cell grid-gutter-checkbox");m.appendChild(u[0]);c.appendChild(m)}if(a.icon){i="grid-gutter-cell grid-gutter-icon ";if(typeof a.icon.cssClass!=="undefined")i+=a.icon.cssClass+" ";if(typeof a.icon.index!=="undefined")i+=(this.getColumnValue(f,a.icon.index,-1)||"")+" ";if(a.icon.ownerDraw!==false)i+=this._getGutterIconClass(k,f,o,s)||"";v=b("div",i);c.appendChild(v)}this._drawGutterCell(h,k,f,o,s)}t=h.row;t.empty();d=t[0];d.style.top=k*this._rowHeight+"px";d.style.left=this._gutterWidth+"px";d.style.height=this._rowHeight+"px";if(isNaN(this._contentSize.width))d.style.width="";else d.style.width=Math.max(this._contentSize.width+2,this._canvasWidth-this._gutterWidth)+"px";r=this._columns;for(j=0,x=r.length;j<x;j++){l=r[j];if(l.hidden)continue;p=l.getCellContents.apply(this,[h,f,o,s,l,w,j]);p&&d.appendChild(p[0])}e.makeElementUnselectable(d);this._gutter&&e.makeElementUnselectable(c);this._updateRowSelectionStyle(h,this._selectedRows,this._selectedIndex);this._options.enabledEvents&&g.EVENT_ROW_UPDATED in this._options.enabledEvents&&this._element.triggerHandler(g.EVENT_ROW_UPDATED,[h])};g.prototype._drawCell=function(o,m,k,h,c,n,l){var d,e,g,a,f,i=c.width||20,j;f=b("div","grid-cell");f.style.width=isNaN(i)?i:i+"px";a=$(f);if(typeof c.hrefIndex!=="undefined")j=this.getColumnValue(m,c.hrefIndex,-1);d=this.getColumnText(m,c,l);a.attr("title",d||null);if(j)a.append($("<a/>").attr("href",j).text(d));else if(d)a.text(d);else a.html("&nbsp;");if(l===n&&h>0){g=h*16-13;c.indentOffset=g;if(k!==0){e=$(b("div","icon grid-tree-icon")).appendTo(a).css("left",g);if(k>0)e.addClass("icon-tree-expanded");else e.addClass("icon-tree-collapsed")}a.css("textIndent",h*16+"px")}c.rowCss&&a.addClass(c.rowCss);return a};g.prototype._drawHeaderCellValue=function(a){var b=$("<div/>").text(a.text||"").addClass("title");a.index===this._indentIndex&&!(this._indentLevels==="undefined"||this._indentLevels===null)&&b.addClass("indented-title");return b};g.prototype._layoutHeader=function(){this._header&&this._headerCanvas.css("left",this._gutterWidth-this._scrollLeft);this._gutter&&this._gutter.css("left",this._scrollLeft)};g.prototype.layout=function(){this._measureCanvasSize();this._cleanUpRows();this._fixScrollPos();this._layoutContentSpacer();this._updateViewport();this._layoutHeader();this._drawHeader();a.logTracePoint("Grid.layout.complete")};g.prototype.redraw=function(){this._fixScrollPos();this._redraw(true)};g.prototype.getColumnValue=function(b,a){return this._dataSource[b][a]};g.prototype.getColumnText=function(e,a,d){var b,c;b=a.getColumnValue.call(this,e,a.index,d);if(typeof b!=="string")c=A.convertValueToDisplayString(b,a.format);else c=b;a.maxLength=Math.max(a.maxLength||0,c.length);return c};g.prototype._getExpandState=function(a){var b=0;if(this._expandStates)if(typeof(this._expandStates[a]==="number"))b=this._expandStates[a];return b};g.prototype._selectRow=function(a,c,b){var f=b&&b.ctrl,e=b&&b.shift,d=b&&b.rightClick;if(f)this._addSelection(a,c,{toggle:true});else if(e){this._clearSelection();this._addSelectionRange(a,c)}else if(d)if(!this._selectedRows||!(a+""in this._selectedRows)){this._clearSelection();this._addSelection(a,c)}else{this._selectedIndex=a;this._updateAriaAttribute()}else{this._clearSelection();this._addSelection(a,c)}};g.prototype.getSelectedRowIndex=function(){return this._selectedIndex};g.prototype.setSelectedRowIndex=function(a){this._clearSelection();this._addSelection(a)};g.prototype.getSelectedDataIndex=function(){return this._getDataIndex(this._selectedIndex)};g.prototype.getSelectedDataIndices=function(){var c,a=this._selectedRows,b=[];if(a)for(c in a)if(a.hasOwnProperty(c))b[b.length]=a[c];return b};g.prototype.ensureDataIndexExpanded=function(c){a.assertParamIsNumber(c,"dataIndex");var b=this._getRowIndex(c);while(b<0||c>0&&b===0){this.expandNode(this._getDataIndex(-b));b=this._getRowIndex(c)}return b};g.prototype.setSelectedDataIndex=function(b,c){a.assertParamIsNumber(b,"dataIndex");var d=c?this.ensureDataIndexExpanded(b):this._getRowIndex(b);this.setSelectedRowIndex(d)};g.prototype.selectionChanged=function(){};g.prototype.selectedIndexChanged=function(){};g.prototype._updateRowSelectionStyle=function(d,e,g){var c,b,a,f;c=d.rowIndex;b=d.row;a=d.gutterRow;f=this._active;b.removeClass("grid-row-selected grid-row-selected-blur grid-row-current");if(a){a.removeClass("grid-gutter-row-selected grid-gutter-row-selected-blur grid-gutter-row-current");a.find("input.checkbox").attr("checked",false)}if(e&&c in e){a&&a.find("input.checkbox").attr("checked",true);if(f){b.addClass("grid-row-selected");a&&a.addClass("grid-gutter-row-selected")}else{b.addClass("grid-row-selected-blur");a&&a.addClass("grid-gutter-row-selected-blur")}}if(c===g){b.addClass("grid-row-current");a&&a.addClass("grid-gutter-row-current")}};g.prototype.focus=function(a){e.tryFocus(this._focus,a)};g.prototype._createContextMenu=function(c,b){a.assertParamIsObject(c,"rowInfo");a.assertParamIsObject(b,"menuOptions");return this._createContextPopupMenuControl(b)};g.prototype._createContextPopupMenuControl=function(b){a.assertParamIsObject(b,"menuOptions");var c=$.map(b.items||[],function(a){return a});return h.BaseControl.createIn(q.PopupMenu,this._element,$.extend({align:"left-bottom"},b,{items:[{childItems:q.sortMenuItems(c)}]}))};g.prototype._onContainerResize=function(){this._measureCanvasSize();if(this._canvasHeight!==this._previousCanvasHeight||this._canvasWidth!==this._previousCanvasWidth){this._previousCanvasHeight=this._canvasHeight;this._previousCanvasWidth=this._canvasWidth;this.layout()}};g.prototype._onColumnResize=function(a){this._fire("columnresize",[a])};g.prototype._onColumnMove=function(a,b){this._fire("columnmove",[a,b])};g.prototype._sortBy=function(d,h){var a=this._sortOrder.slice(0),c,g,b,f=false,e;if(d){for(c=0,g=a.length;c<g;c++){b=a[c];if(b.index===d.index){a.splice(c,1);f=true;break}}if(f)b.order=b.order==="asc"?"desc":"asc";else b={index:d.index,order:"asc"};if(h)a.push(b);else a=[b]}e=this._getSortColumns(a);this._onSort(a,e)};g.prototype.onSort=function(b,c){if(this._options.autoSort){this._trySorting(b,c);this._sortOrder=b;this.layout()}a.logTracePoint("Grid.OnSort.Complete")};g.prototype._trySorting=function(b,a){var d=this;function c(c,g,d,e){var a=d[c.index],b=e[c.index];return typeof a==="undefined"||a===null?typeof b==="undefined"||b===null?0:-1:f.StringUtils.localeIgnoreCaseComparer(a,b)}if(!a)a=this._getSortColumns(b);this._dataSource.sort(function(j,k){for(var h,e,g,i,f=0;f<b.length;f++){h=b[f];g=a[f];i=g.comparer||c;e=i.call(d,g,h.order,j,k);if(e===0)continue;else return h.order==="desc"?-e:e}return 0})};g.prototype._getRowInfoFromEvent=function(b,a){return $(b.target).closest(a).data("grid-row-info")};g.prototype._onRowMouseDown=function(b){var a=this._getRowInfoFromEvent(b,".grid-row");if(a)if($(b.target).hasClass("grid-tree-icon")&&b.which===1)this._onToggle(a);else{this._selectRow(a.rowIndex,a.dataIndex,{ctrl:b.ctrlKey,shift:b.shiftKey,rightClick:b.which===3});return this._handleEvent(b,this.onRowMouseDown,"rowmousedown",{row:a.row,rowInfo:a,rowIndex:a.rowIndex,dataIndex:a.dataIndex})}};g.prototype.onRowMouseDown=function(){};g.prototype.onRowClick=function(){};g.prototype.onRowDoubleClick=function(){};g.prototype.onGutterClick=function(a){this._options.gutter.contextMenu&&this._showContextMenu(a&&a.rowInfo)};g.prototype.onEnterKey=function(a){if(a.event.altKey){this._showContextMenu(a.rowInfo);return false}};g.prototype.onDeleteKey=function(){};g.prototype._onOpenRowDetail=function(e,d){var a,b,c;if(this._handleEvent(e,this.onOpenRowDetail,"openRowDetail",d)!==false){a=this._options.openRowDetail;if(a){if($.isFunction(a))a=a.call(this,this._selectedIndex);if(a){if(typeof a!=="string"){b=this.getColumnValue(this._selectedIndex,a.hrefIndex,-1);c=a.target}else b=a;if(b)if(c)j.ActionManager.performAction(j.CommonActions.ACTION_WINDOW_OPEN,{url:b,target:c,features:this._options.openRowDetail.targetFeatures});else j.ActionManager.performAction(j.CommonActions.ACTION_WINDOW_NAVIGATE,{url:b})}return false}}else return false};g.prototype.onOpenRowDetail=function(){};g.prototype.onContextMenu=function(a){this._showContextMenu(a&&a.rowInfo)};g.prototype._onBlur=function(){m(l,"(grid) focus out");this._active=false;this._updateSelectionStyles()};g.prototype._onFocus=function(){m(l,"(grid) focus in");this._active=true;this._updateSelectionStyles();this._updateAriaAttribute()};g.prototype._onKeyDown=function(a){var b={lo:-1,hi:-1},c=e.KeyCode,f=this._canvas,g,d;m(l,"(grid) key down");if(this._copyInProgress){if(a.keyCode===c.ESCAPE)this._cancelable&&this._cancelable.cancel();return false}if(this._count>0)b={lo:0,hi:this._expandedCount-1};this._selectedIndex<0&&this._addSelection(b.lo);switch(a.keyCode){case 65:if(a.ctrlKey)this._selectAll();else return;break;case 67:if(a.ctrlKey)this._copySelectedItems();else return;break;case 121:if(a.shiftKey)return this._onContextMenu();else return;break;case c.DOWN:this._clearSelection();if(a.ctrlKey)if(a.shiftKey)this._addSelectionRange(b.hi);else this._addSelection(b.hi);else if(a.shiftKey)this._addSelectionRange(Math.min(this._selectedIndex+1,b.hi));else this._addSelection(Math.min(this._selectedIndex+1,b.hi));break;case c.UP:this._clearSelection();if(a.ctrlKey)if(a.shiftKey)this._addSelectionRange(b.lo);else this._addSelection(b.lo);else if(a.shiftKey)this._addSelectionRange(Math.max(this._selectedIndex-1,b.lo));else this._addSelection(Math.max(this._selectedIndex-1,b.lo));break;case c.PAGE_DOWN:case c.PAGE_UP:g=f[0].clientHeight;d=Math.floor(g/this._rowHeight);this._clearSelection();if(a.keyCode===c.PAGE_DOWN)if(a.shiftKey)this._addSelectionRange(Math.min(this._selectedIndex+d,b.hi));else this._addSelection(Math.min(this._selectedIndex+d,b.hi));else if(a.shiftKey)this._addSelectionRange(Math.max(this._selectedIndex-d,b.lo));else this._addSelection(Math.max(this._selectedIndex-d,b.lo));break;case c.RIGHT:if(!this.tryToggle(true,a.shiftKey))f.scrollLeft(f.scrollLeft()+50);else{this._clearSelection();this._addSelection(this._selectedIndex)}break;case c.LEFT:if(!this.tryToggle(false,a.shiftKey))f.scrollLeft(f.scrollLeft()-50);else{this._clearSelection();this._addSelection(this._selectedIndex)}break;case c.ENTER:return this._onEnterKey(a);case c.DELETE:return this._onDeleteKey(a);case c.HOME:this._clearSelection();if(a.shiftKey)this._addSelectionRange(b.lo);else this._addSelection(b.lo);break;case c.END:this._clearSelection();if(a.shiftKey)this._addSelectionRange(b.hi);else this._addSelection(b.hi);break;case c.ESCAPE:this._tryFinishColumnMoving(true);break;default:return}this.getSelectedRowIntoView();this._fire("keydown",[a.keyCode,a.ctrlKey,a.shiftKey,a.altKey]);a.preventDefault()};g.prototype._onKeyUp=function(){return};g.prototype.enableEvent=function(c){a.assertParamIsStringNotEmpty(c,"eventName");var b=this._options.enabledEvents;if(!b){b={};this._options.enabledEvents=b}b[c]=true};g.prototype.disableEvent=function(c){a.assertParamIsStringNotEmpty(c,"eventName");var b=this._options.enabledEvents;if(b)delete b[c]};g.prototype.getExpandStates=function(){return this._expandStates};g.prototype.beginFormatTable=function(b,e){a.assertParamIsFunction(b,"operationCompleteCallback");this._beginEnsureSelectionIsAvailable(c(this,function(){var a=this,e,c;if(!(a._cancelable&&a._cancelable.canceled)){e=new d.TabDelimitedTableFormatter(a);c=e.getTableFromSelectedItems()}$.isFunction(b)&&b(c)},e))};g.prototype._createElement=function(){i.prototype._createElement.call(this);this._buildDom()};g.prototype._buildDom=function(){var c=document.createDocumentFragment(),a,d;a=this._options.gutter;d=a&&(a.contextMenu||a.icon||a.checkbox);this._focus=$(b("div","grid-focus")).attr("tabIndex",0).attr("role","grid");c.appendChild(this._focus[0]);this._canvas=$(b("div","grid-canvas"));this._contentSpacer=$(b("div","grid-content-spacer"));this._canvas.append(this._contentSpacer);if(this._options.header){this._element.addClass("has-header");this._header=$(b("div","grid-header"));this._header.bind("contextmenu",function(a){a.preventDefault();a.stopPropagation();return false});this._headerCanvas=$(b("div","grid-header-canvas"));this._header.append(this._headerCanvas);c.appendChild(this._header[0])}if(d){this._element.addClass("has-gutter");this._gutter=$(b("div","grid-gutter"));this._canvas.append(this._gutter);if(this._header){this._gutterHeader=$(b("div","grid-gutter-header"));this._header.append(this._gutterHeader)}}c.appendChild(this._canvas[0]);this._element.append(c)};g.prototype._attachEvents=function(){var b=this;this._bind(window,"resize",c(this,this._onContainerResize));this._bind("mousedown",c(this,this._onContainerMouseDown));this._bind(this._focus,"keydown",c(this,this._onKeyDown));this._bind(this._focus,"keyup",c(this,this._onKeyUp));this._bind(this._focus,"focus",c(this,this._onFocus));this._bind(this._focus,"blur",c(this,this._onBlur));if(this._gutter&&this._options.gutter&&this._options.gutter.contextMenu){this._bind(this._focus,"contextmenu",c(this,this._onContextMenu));this._bind("contextmenu",c(this,this._onContextMenu))}this._bind(this._canvas,"click",c(this,this._onRowClick));this._bind(this._canvas,"dblclick",c(this,this._onRowDoubleClick));this._bind(this._canvas,"mousedown",c(this,this._onRowMouseDown));this._bind(this._canvas,"scroll",c(this,this._onCanvasScroll));this._bind(this._canvas,"selectstart",c(this,this._onSelectStart));if(this._header){this._bind(this._header,"mousedown",c(this,this._onHeaderMouseDown));this._bind(this._header,"mouseup",c(this,this._onHeaderMouseUp));this._bind(this._header,"click",c(this,this._onHeaderClick));this._bind(this._header,"dblclick",c(this,this._onHeaderDblClick))}if(this._gutter){this._bind(this._gutter,"click",c(this,this._onGutterClick));this._gutter.hover(function(a){$(a.target).closest(".grid-gutter-row").addClass("grid-gutter-row-hover")},function(a){$(a.target).closest(".grid-gutter-row").removeClass("grid-gutter-row-hover")})}this._setupDragDrop();this._element.parents(".ui-tabs").bind("tabsshow",function(){b._element.is(":visible")&&b.layout()});a.logTracePoint("Grid._attachEvents.complete")};g.prototype._setupDragDrop=function(){var c=this,b=this._options.draggable,e,d,a;if(b){e={axis:"y",helperClass:"grid-row-dragging",zIndex:1e3,appendTo:this._canvas,handle:".grid-row",opacity:.7,scope:this.getTypeName(),cursorAt:{top:this._rowHeight/2},dropBehaviour:true};if(typeof b!=="object")b={};this._draggable=$.extend({},e,b);b=$.extend(e,b,{helper:function(f){var g=$(f.target),e,b;e=g.closest(".grid-row");if(e.length){b=e.data("grid-row-info");a={dataIndex:+b.dataIndex,rowIndex:+b.rowIndex};return c._rowDragCreateHelper(a,f,d)}else{b=null;a=null;return $("<div />")}},drag:function(e,b){b.draggable=d;b.draggingRowInfo=a;return c._rowDrag(a,e,b)},start:function(e,b){if(a){b.draggable=d;b.draggingRowInfo=a;c._draggingRowInfo=a;return c._rowDragStart(a,e,b)}else return false},stop:function(e,b){b.draggable=d;b.draggingRowInfo=a;c._draggingRowInfo=null;return c._rowDragStop(a,e,b)}});this._droppable={tolerance:"intersect",hoverClass:"grid-row-drop-active"};if(typeof this._options.droppable==="object"){$.extend(this._droppable,this._options.droppable);if(this._droppable.accept)if(!$.isFunction(this._droppable.accept))this._droppable.acceptSelector=this._droppable.accept}this._canvas.draggable(b);d=this._canvas.data("draggable");this._resetRowAcceptStatus();this._resetRowOverStatus()}};g.prototype._resetRowOverStatus=function(){this._ddRowOverStatus={}};g.prototype._rowDropAccept=function(d,g,f,e){var b=this._rows[d.dataIndex],c=this._droppable.accept,a;if(b){if(c)return c.call(this,f,$.extend({},e,{droppingRowInfo:b}));a=this._droppable.acceptSelector;return a?b.row.is(a):true}else return false};g.prototype._rowDropActivate=function(c,f,e,d){var a=this._rows[c.dataIndex],b=this._droppable.activate;if(a){this._droppable.activeClass&&a.row.addClass(this._droppable.activeClass);if(b)return b.call(this,e,$.extend({},d,{droppingRowInfo:a}))}};g.prototype._rowDropDeactivate=function(c,f,e,d){var a=this._rows[c.dataIndex],b=this._droppable.deactivate;if(a){this._droppable.activeClass&&a.row.removeClass(this._droppable.activeClass);if(b)return b.call(this,e,$.extend({},d,{droppingRowInfo:a}))}};g.prototype._rowDropOver=function(e,g,f,d){var a=this._rows[e.dataIndex],b=this._droppable,c=this._droppable.over;if(a){d.draggable.dropped=true;b.hoverClass&&a.row.addClass(b.hoverClass);c&&c.call(this,f,$.extend({},d,{droppingRowInfo:a}))}};g.prototype._rowDropOut=function(e,g,f,d){var a=this._rows[e.dataIndex],b=this._droppable,c=this._droppable.out;if(a){d.draggable.dropped=false;b.hoverClass&&a.row.removeClass(b.hoverClass);c&&c.call(this,f,$.extend({},d,{droppingRowInfo:a}))}};g.prototype._rowDrop=function(c,f,e,d){var b=this._rows[c.dataIndex],a=this._droppable;if(b){a.hoverClass&&b.row.removeClass(a.hoverClass);a.activeClass&&b.row.removeClass(a.activeClass);a.drop&&a.drop.call(this,e,$.extend({},d,{droppingRowInfo:b}))}};g.prototype._rowDragCreateHelper=function(b,d,c){var a;if($.isFunction(this._draggable.helper))return this._draggable.helper.call(this,d,$.extend({},c,{draggingRowInfo:b}));a=this._rows[b.dataIndex].row.clone();a.removeClass("grid-row-selected grid-row-selected-blur grid-row-current");a.addClass(this._draggable.helperClass);a.css("position","absolute");return a};g.prototype._rowDrag=function(b,e,a){var d=this,c=this._getDragOverRows(),f=this._draggable.drag;if(f&&f.call(this,e,a)===false)return false;$.each(this._rows,function(f,h){var g;if(+f!==+b.dataIndex){g={dataIndex:+f,rowIndex:+h.rowIndex};if(d._rowDropTryActivate(g,b,e,a))if(d._rowIntersect(a.draggable,g)){if(!c[f]){c[f]=true;d._rowDropOver(g,b,e,a)}}else if(c[f]){delete c[f];d._rowDropOut(g,b,e,a)}}})};g.prototype._rowDragStart=function(a,d,c){var e=this,b=this._draggable.start;if(b&&b.call(this,d,c)===false)return false;$.each(this._rows,function(b,f){+b!==a.dataIndex&&e._rowDropTryActivate({dataIndex:+b,rowIndex:f.rowIndex},a,d,c)})};g.prototype._rowDragStop=function(b,d,a){var c=this,e=this._draggable.stop;if(e&&e.call(this,d,a)===false)return false;$.each(this._rows,function(f,h){var e,g;if(+f!==+b.dataIndex){e={dataIndex:Number(f),rowIndex:h.rowIndex};if(c._rowDropTryActivate(e,b,d,a)){if(c._rowIntersect(a.draggable,e)){g=false;c._rowDrop(e,b,d,a)}c._rowDropDeactivate(e,b,d,a)}}return g});this._resetRowAcceptStatus();this._resetRowOverStatus()};g.prototype._takeMeasurements=function(){var c,g,f,h,d,a,e;if(this._options.sharedMeasurements)a=p;if(!a){a={};e=this._options.coreCssClass;if(this._options.cssClass)e+=" "+this._options.cssClass;c=$(b("div",e)).appendTo(document.body).css("position","absolute").css("left",-5e3).css("top",-5e3).width(1e3).height(500);g=$(b("div","grid-row grid-row-normal")).appendTo(c);f=$(b("div","grid-cell")).width(100).appendTo(g).text("1");a.rowHeight=g.outerHeight();a.cellOffset=f.outerWidth()-100;h=$(b("div")).appendTo(f).css("overflow","hidden").css("width","1em").css("height","1ex");a.unitEx=h.outerHeight();d=$(b("div","grid-gutter"));d.append(b("div","grid-gutter-row grid-gutter-row-selected"));d.appendTo(c);a.gutterWidth=d[0].clientWidth;c.remove();if(this._options.sharedMeasurements)p=a}this._unitEx=a.unitEx;this._rowHeight=a.rowHeight;this._cellOffset=a.cellOffset;if(this._gutter)this._gutterWidth=a.gutterWidth;else this._gutterWidth=0};g.prototype._ensureSelectedIndex=function(a){var b=this._selectedIndex;if(typeof a==="number")this._selectedIndex=a;if(this._selectedIndex>=0){if(this._count<=this._selectedIndex)this._selectedIndex=this._count-1;this._selectedIndex!==b&&this._addSelection(this._selectedIndex)}};g.prototype._determineIndentIndex=function(){var b=this._columns,a,c;for(a=0,c=b.length;a<c;a++)if(b[a].indent){this._indentIndex=a;return}this._indentIndex=0};g.prototype._updateRanges=function(){var b=0,c=0,e=this._count,a=[],d=0,f;if(this._expandStates){while(b<e){f=this._expandStates[b];if(f<0){a[a.length]=[c,b];d+=b-c+1;b+=1-f;c=b}else b++}if(c<e){a[a.length]=[c,e-1];d+=e-c}}else{d=e;a[a.length]=[0,d]}this._expandedCount=d;this._visibleRange=a};g.prototype._updateExpansionStateAndRedraw=function(d){a.assertParamIsFunction(d,"action");var c,b=this._selectedIndex;if(b>=0)c=this._getDataIndex(b);d.call(this);if(b>=0){this._clearSelection();this._addSelection(Math.abs(this._getRowIndex(c)))}this._layoutContentSpacer();this._redraw()};g.prototype._updateViewport=function(n){var f,c,d,g,l,o=this._count,a,b,h,k,i=[],j=[],e=[],p=this._expandStates||[],m=this._expandedCount-1;f=this._getVisibleRowIndices();c=f.first;d=f.last;c=Math.max(0,c-this._options.extendViewportBy);d=Math.min(m,d+this._options.extendViewportBy);g=Math.max(0,c-this._options.payloadSize);l=Math.min(m,d+this._options.payloadSize);b=this._getDataIndex(g);k=c;for(a=g;a<=l&&b<o;a++){if(a<c)i[i.length]=[a,b];else if(a>d)j[j.length]=[a,b];else{e[e.length]=[a,b];k=a}h=p[b];if(h<0)b+=1-h;else b++}this.cacheRows(i,e,j);this._drawRows(e,n)};g.prototype._cleanUpRows=function(){var b=this._rows,c,a,d=this._gutter;for(a in b)if(b.hasOwnProperty(a)){c=b[a];c.row.remove();d&&c.gutterRow.remove()}this._rows={}};g.prototype._getGutterIconClass=function(){return""};g.prototype._drawGutterCell=function(){};g.prototype._drawHeader=function(){var d,p,a,o=this._columns,l,c,f,k,h,q,r,n=this._sortOrder,j,i,m,g;if(this._header){j=document.createDocumentFragment();for(d=0,p=o.length;d<p;d++){a=o[d];if(a.hidden)continue;c=b("div","grid-header-column");l=$(c).attr("title",a.text);c.style.width=(a.width||20)+"px";c._data={columnIndex:d,header:true};f=b("div","separator");if(a.fixed)f.style.cursor="auto";q=$(f);f._data={columnIndex:d,separator:true};c.appendChild(f);h=a.getHeaderCellContents.apply(this,[a]);a.headerCss&&h.addClass(a.headerCss);c.appendChild(h&&h[0]);k=b("div","sort-handle");r=$(k);for(i=0,m=n.length;i<m;i++){g=n[i];if(g.index===a.index){if(g.order==="asc")l.addClass("ascending");else g.order==="desc"&&l.addClass("descending");break}}c.appendChild(k);j.appendChild(c)}this._headerCanvas.empty();this._columnMovingElement=null;this._headerCanvas[0].appendChild(j);e.makeElementUnselectable(this._header[0])}};g.prototype._layoutContentSpacer=function(){var a=0,b,c,g,f=this._columns,e,d;for(c=0,g=f.length;c<g;c++){if(f[c].hidden)continue;a+=(f[c].width||20)+this._cellOffset}a=a+2;b=Math.max(1,this._expandedCount*this._rowHeight);this._contentSpacer.width(a);this._contentSpacer.height(b);this._gutter&&this._gutter.height(b);this._ignoreScroll=true;try{e=Math.max(0,Math.min(this._scrollTop,b-this._canvasHeight));if(e!==this._scrollTop){this._scrollTop=e;this._canvas[0].scrollTop=e}d=Math.max(0,Math.min(this._scrollLeft,a-this._canvasWidth));if(d!==this._scrollLeft){this._scrollLeft=d;this._canvas[0].scrollLeft=d}}finally{this._ignoreScroll=false}this._contentSize.width=a;this._contentSize.height=b};g.prototype._fixScrollPos=function(){var a=this._ignoreScroll;this._ignoreScroll=true;try{this._canvas[0].scrollLeft=this._scrollLeft;this._canvas[0].scrollTop=this._scrollTop}finally{this._ignoreScroll=a}};g.prototype._redraw=function(a){this._layoutHeader();this._updateViewport(a)};g.prototype._selectAll=function(){if(this._count>0&&this._options.allowMultiSelect!==false){this._clearSelection();this._selectionStart=0;var a=Math.max(0,this._selectedIndex);this._addSelectionRange(this._count-1,undefined,{doNotFireEvent:true});this._selectedIndex=a;this._updateSelectionStyles();this._selectionChanged()}};g.prototype._clearSelection=function(){this._selectionCount=0;this._selectedRows=null};g.prototype._addSelection=function(a,c,b){var d,e=b&&b.keepSelectionStart,f=b&&b.doNotFireEvent,g=b&&b.toggle;if(this._options.allowMultiSelect===false){e=false;this._clearSelection()}if(!this._selectedRows)this._selectedRows={};if(a>=0){d=true;if(!(a+""in this._selectedRows))this._selectionCount++;else if(g){d=false;this._selectionCount=Math.max(0,this._selectionCount-1);delete this._selectedRows[a]}if(typeof c!=="number")c=this._getDataIndex(a);if(d)this._selectedRows[a]=c;this._selectedIndex=a;this._updateAriaAttribute();if(this._selectionStart<0||!e)this._selectionStart=a}else{c=-1;this._selectedIndex=-1}if(!f){this._updateSelectionStyles();this._selectionChanged();this._selectedIndexChanged(this._selectedIndex,c)}};g.prototype._addSelectionRange=function(b,a,h){var d,i,c,f,j=h&&h.doNotFireEvent,g=-1,e;if(this._options.allowMultiSelect===false)this._addSelection(b,a);else{if(this._selectedRows)g=this._selectedRows[this._selectedIndex];if(this._selectionStart<0)this._selectionStart=b;d=Math.min(this._selectionStart,b);i=Math.max(this._selectionStart,b);if(typeof a!=="number"||d!==b)a=this._getDataIndex(d);for(c=d;c<=i;c++){this._addSelection(c,a,{keepSelectionStart:true,doNotFireEvent:true});if(c===b)e=a;f=this._getExpandState(a);if(f<0)a+=1-f;else a++}this._selectedIndex=b;this._updateAriaAttribute();if(!j){this._updateSelectionStyles();this._selectionChanged();g!==e&&this._selectedIndexChanged(this._selectedIndex,e)}}};g.prototype._updateAriaAttribute=function(){var a,c,b;if(this._active){c=this._getDataIndex(this._selectedIndex);if(c>=0){a=this.getRowInfo(c);if(a&&a.row){b=a.row.attr("id");if(b!==this._activeAriaId){this._focus.attr("aria-activedescendant",b);this._activeAriaId=b}}}}};g.prototype._updateSelectionStyles=function(){this.delayExecute("updateSelectionStyles",10,true,function(){var a,d=this._selectedRows,e=this._selectedIndex,b=this._rows,c;for(a in b)if(b.hasOwnProperty(a)){c=b[a];this._updateRowSelectionStyle(c,d,e)}})};g.prototype._selectionChanged=function(){this.selectionChanged(this._selectedIndex,this._selectionCount,this._selectedRows);this._fire("selectionchanged",{selectedIndex:this._selectedIndex,selectedCount:this._selectionCount,selectedRows:this._selectedRows})};g.prototype._selectedIndexChanged=function(b,a){this.selectedIndexChanged(b,a);this._fire(g.EVENT_SELECTED_INDEX_CHANGED,[b,a])};g.prototype._showContextMenu=function(b){var d,c,a;a=this._options.contextMenu;if(!a)return;if(b){d=b.gutterRow;c=this._dataSource[b.dataIndex];a=$.extend({},a,{contextInfo:{rowInfo:b,item:c}});if(!c.root){if(a.items)if($.isFunction(a.items))a.items=a.items.call(this,a.contextInfo);else a.items=a.items.slice(0);else a.items=[];if(this._popupMenu){this._popupMenu.dispose();this._popupMenu=null}this._popupMenu=this._createContextMenu(b,a);f.delay(this,10,function(){this._popupMenu.popup(this._focus[0],d)})}}};g.prototype._onContainerMouseDown=function(){this.focus(10)};g.prototype._measureCanvasSize=function(){this._canvasHeight=this._canvas[0].clientHeight;this._canvasWidth=this._canvas[0].clientWidth};g.prototype._setupDragEvents=function(){this._bind(window.document,"mousemove",c(this,this._onDocumentMouseMove),true);this._bind(window.document,"mouseup",c(this,this._onDocumentMouseUp),true)};g.prototype._clearDragEvents=function(){this._unbind(window.document,"mousemove",null,true);this._unbind(window.document,"mouseup",null,true)};g.prototype._onDocumentMouseMove=function(f){var c,e,d,a=this._columnSizing,b=this._columnMoving;if(a&&a.active===true){c=f.pageX-a.origin;d=Math.max(this._cellMinWidth,a.originalWidth+c);e=this._columns[a.index];e.width=d;this._applyColumnSizing(a.index);this._moveSizingElement(a.index)}if(b&&b.state>0){c=f.pageX-b.origin;if(c!==0){b.state=2;this._moveColumnMovingElement(b.index,b.left+c)}}};g.prototype._onDocumentMouseUp=function(){f.delay(this,0,function(){this._tryFinishColumnSizing(false);this._tryFinishColumnMoving(false);this._clearDragEvents()});return false};g.prototype._onHeaderMouseDown=function(c){var b,a,f,g,e,d;if(c.which!==1)return;e=$(c.target).closest(".separator");if(e.length>0){b=e[0]._data.columnIndex;a=this._columns[b];if(!a.fixed){this._columnSizing={active:true,index:b,originalWidth:a.width,origin:c.pageX};this._moveSizingElement(b);this._setupDragEvents();return false}}else{d=$(c.target).closest(".grid-header-column");if(d.length>0){b=d[0]._data.columnIndex;a=this._columns[b];if(this._options.allowMoveColumns&&!a.fixed&&a.canMove){this._columnMoving={state:1,index:b,width:a.width,origin:c.pageX};f=0;g=0;while(g<b){a=this._columns[g++];if(!a.hidden)f+=a.width}this._columnMoving.left=f;this._setupDragEvents();return false}}}};g.prototype._onHeaderMouseUp=function(){return};g.prototype._onHeaderClick=function(c){var d,a,b,e;b=$(c.target).closest(".grid-header-column");if(b.length>0)if(!this._columnSizing){e=$(c.target).closest(".separator");if(e.length>0)return false;else{d=b[0]._data.columnIndex;a=this._columns[d];a.canSortBy&&!a.fixed&&this._sortBy(a,c.shiftKey)}}};g.prototype._onHeaderDblClick=function(g){var d,b,a,c,f,e;d=$(g.target).closest(".separator");if(d.length>0){this._tryFinishColumnSizing(true);this._tryFinishColumnMoving(true);b=d[0]._data.columnIndex;a=this._columns[b];c=Math.max(a.maxLength||0,3);f=1.1+.7*Math.exp(-c/20);e=a.width;a.width=(a.indentOffset||0)+Math.round(c*f*this._unitEx);this._applyColumnSizing(b,e,true);return false}};g.prototype._moveSizingElement=function(c){var e=this._canvas,h=e[0],a=this._sizingElement,d,g=0,f=this._gutterWidth;if(!a){if(c<0)return;a=$(b("div","grid-column-sizing")).appendTo(e);this._sizingElement=a}a.height(h.clientHeight-1);a.css("top",this._scrollTop);if(c<0)a.css("left",-5e3).css("top",-5e3).height(0);else{while(g<=c){d=this._columns[g++];if(!d.hidden)f+=d.width}a.css("left",f-1)}};g.prototype._getVisibleColumnIndex=function(b){a.assertParamIsNumber(b,"columnIndex");var c=0,d=0,e=this._columns.length;a.assert(b<e,"Index out of array bounds");if(this._columns[b].hidden)return-1;while(c<b){if(!this._columns[c].hidden)d++;c++}return d};g.prototype._applyColumnSizing=function(d,b,f){var e=this._getVisibleColumnIndex(d)+1,a=this._columns[d],c=false;b=b||-1;if(a){c=a.width!==b;$(".grid-header-column:nth-child("+e+")",this._headerCanvas).width(a.width)}if(f===true){c&&this.layout();this._onColumnResize(a)}};g.prototype._tryFinishColumnSizing=function(b){var a=this._columnSizing;if(a){if(a.active===true){!b&&this._applyColumnSizing(a.index,a.originalWidth,true);this._moveSizingElement(-1)}this._columnSizing=null}};g.prototype._moveColumnMovingElement=function(e,i){var k=this._headerCanvas,l=this._canvas,d=this._columnMovingElement,c=this._columnMovingPinElement,a,m=this._columns.length,h=this._gutterWidth,g=0,f=0,j;if(!d){if(e<0)return;d=$(b("div","grid-column-moving")).appendTo(k);this._columnMovingElement=d;c=$(b("div","grid-column-moving-placer")).appendTo(l).height(4).css("left",-500).css("top",-500);this._columnMovingPinElement=c}if(e<0){d.css("left",-5e5);c.css("left",-500).css("top",-500)}else{a=this._columns[e];d.width(a.width).css("left",i).css("top",0).text(a.text);j=i+(a.width>>1);while(g<m){a=this._columns[g];if(!a.hidden){if(j-h>a.width/2)f=g+1;else break;h+=a.width}g++}if(f<e||f>e+1){this._columnInsert=f;c.css("left",h-4).css("top",this._scrollTop)}else{this._columnInsert=-1;c.css("left",-500).css("top",-500)}}};g.prototype._applyColumnMoving=function(b,a){var e,d,c=this._columns;if(a>=0){if(a>b)a--;e=c[b];d=c[a];if(this._options.allowMoveColumns&&!d.fixed&&d.canMove){c.splice(b,1);c.splice(a,0,e);this._determineIndentIndex();this.layout();this._onColumnMove(b,a)}}};g.prototype._tryFinishColumnMoving=function(b){var a=this._columnMoving;if(a){if(a.state>1){this._moveColumnMovingElement(-1);!b&&this._applyColumnMoving(a.index,this._columnInsert)}this._columnMoving=null}};g.prototype._getSortColumns=function(g){var h=this._columns,e,a,j,i,f=[],b,d,c;for(a=0,j=g.length;a<j;a++){i=g[a];for(b=0,d=h.length;b<d;b++){c=h[b];if(c.index===i.index){e=c;break}}f.push(e)}return f};g.prototype._onSort=function(b,a){this.onSort(b,a)!==false&&this._fire("sort",[{sortOrder:b,sortColumns:a}])};g.prototype._onSelectStart=function(){return false};g.prototype._onCanvasScroll=function(){var a=this._canvas[0];this._resetScroll=true;this._scrollLeft=a.scrollLeft;this._scrollTop=a.scrollTop;!this._ignoreScroll&&this._redraw();return false};g.prototype._handleEvent=function(g,d,f,e){var b,c=this._selectedIndex,a;b=this._getDataIndex(c);a={rowIndex:c,dataIndex:b,rowInfo:this._rows[b],event:g};e&&$.extend(a,e);return!d||d.call(this,a)!==false?this._fire(f,a):false};g.prototype._onRowClick=function(b){var a=this._getRowInfoFromEvent(b,".grid-row");if(a)return this._handleEvent(b,this.onRowClick,"rowclicked",{row:a.row,rowInfo:a,rowIndex:a.rowIndex,dataIndex:a.dataIndex})};g.prototype._onRowDoubleClick=function(b){var a=this._getRowInfoFromEvent(b,".grid-row");if(a)if(!$(b.target).hasClass("grid-tree-icon"))return this._handleEvent(b,this.onRowDoubleClick,"rowdblclick",{row:a.row,rowInfo:a,rowIndex:a.rowIndex,dataIndex:a.dataIndex})!==false?this._onOpenRowDetail(b,{rowIndex:a.rowIndex,dataIndex:a.dataIndex}):false};g.prototype._onGutterClick=function(b){var a=this._getRowInfoFromEvent(b,".grid-gutter-row"),c;if(a){if(this._options.gutter.checkbox){c=$(b.target);c.hasClass("checkbox")&&this._addSelection(a.rowIndex,a.dataIndex,{toggle:true})}else(!this._selectedRows||typeof this._selectedRows[a.rowIndex]!=="number")&&this._selectRow(a.rowIndex,a.dataIndex);return this._handleEvent(b,this.onGutterClick,"gutterclick",{gutterRow:a.gutterRow,rowInfo:a,rowIndex:a.rowIndex,dataIndex:a.dataIndex})}};g.prototype._onEnterKey=function(a){return this._handleEvent(a,this.onEnterKey,"enterkey")!==false?this._onOpenRowDetail(a):false};g.prototype._onDeleteKey=function(a){return this._handleEvent(a,this.onDeleteKey,"deletekey")};g.prototype._onContextMenu=function(b,a){this._handleEvent(b,this.onContextMenu,"contextMenu",a);return false};g.prototype._onToggle=function(a){var b;if(this._expandStates){b=this._expandStates[a.dataIndex];if(b!==0){if(b>0)this.collapseNode(a.dataIndex);else b<0&&this.expandNode(a.dataIndex);this._clearSelection();this._addSelection(Math.min(a.rowIndex,this._expandedCount-1),a.dataIndex);this._layoutContentSpacer();this._redraw()}}};g.prototype._copySelectedItems=function(){var b=this,e={cancellable:true,message:B.CopyProgressPleaseWait,cancelCallback:c(this,function(){})},d=new o.LongRunningOperation(b._element,e);a.logTracePoint("TFS.UI.Controls.Grids._copySelectedItems.start");d.beginOperation(c(b,function(c){b._cancelable=c;b._beginCopySelection(function(){d.endOperation();a.logTracePoint("TFS.UI.Controls.Grids._copySelectedItems.complete")})}))};g.prototype._beginEnsureSelectionIsAvailable=function(b){a.assertParamIsFunction(b,"itemsAvailableCallback");b()};g.prototype._beginCopySelection=function(a,b){if(this._copyInProgress)return;this.getSelectionCount()<=0&&$.isFunction(a)&&a();this._copyInProgress=true;this.beginFormatTable(c(this,function(b){!(this._cancelable&&this._cancelable.canceled)&&o.Clipboard.copyToClipboard(b);this._copyInProgress=false;$.isFunction(a)&&a()}),b)};return g}(h.BaseControl);i.Grid=g;n.initClassPrototype(g,{_dataSource:[],_expandStates:null,_indentLevels:null,_columns:[],_sortOrder:[],_visibleRange:[],_count:0,_expandedCount:0,_selectedIndex:-1,_indentIndex:0,_selectionStart:-1,_selectionCount:0,_selectedRows:null,_rowHeight:20,_cellOffset:0,_gutterWidth:30,_contentSize:null,_rows:{},_focus:null,_scroller:null,_canvas:null,_canvasHeight:300,_canvasWidth:300,_contentSpacer:null,_header:null,_headerCanvas:null,_gutter:null,_gutterHeader:null,_popupMenu:null,_columnSizing:null,_columnMoving:null,_columnMovingElement:null,_columnMovingPinElement:null,_columnInsert:null,_unitEx:null,_sizingElement:null,_resetScroll:false,_ignoreScroll:false,_scrollTop:0,_scrollLeft:0,_ddRowAcceptStatus:null,_ddRowOverStatus:null,_droppable:null,_draggable:null,_draggingRowInfo:null,_cancelable:null,_active:false,_activeAriaId:null,_cellMinWidth:15,_copyInProgress:false});h.Enhancement.registerJQueryWidget(g,"grid");var k=function(h){__extends(g,h);function g(a){h.call(this,a)}g._typeName="tfs.checkboxselectiongrid";g._DEFAULT_LABEL_COLUMN=1;g._HEADER_CHECKBOX_ID="header-checkbox";g.prototype.initializeOptions=function(b){a.assert(Boolean(b),"Expected options argument");a.assert(Boolean(b.columns),"Expected columns information in the options");h.prototype.initializeOptions.call(this,$.extend({asyncInit:false},b));this._selectAllLabel=b.selectAllLabel||"";this._labelColumnIndex=b.labelColumnIndex||g._DEFAULT_LABEL_COLUMN;this._updateOptions(b)};g.prototype.setGridItems=function(c,b){a.assert(Boolean(c),"Expected gridItems argument");a.assert(Boolean(b),"Expected checkedItemIds argument");this.dataProvider=new d.FieldDataProvider(c,{sort:this._options.sort});this.gridAdapter=d.HierarchicalGridDataAdapter.bindAdapter(d.ChecklistDataAdapter,this.dataProvider,this,{noColumn:true,checkedItemIds:b})};g.prototype.getCheckedItemIds=function(){var a=[];if(this.gridAdapter)a=this.gridAdapter.getCheckedItemIds();return a};g.prototype._drawHeaderCellValue=function(a){var f=$("<div/>"),b,e;if(a.index!==d.ChecklistDataAdapter._CHECKBOX_COLUMN_INDEX)return h.prototype._drawHeaderCellValue.call(this,a);e=false;if(a.hasOwnProperty("checked"))e=a.checked;b=$("<input type='checkbox' id='"+g._HEADER_CHECKBOX_ID+"'>").attr("checked",e);this._bind(b,"click",c(this,this._onHeaderCheckboxClicked));f.append(b);f.append(this._createLabel(g._HEADER_CHECKBOX_ID,this._selectAllLabel));return f};g.prototype.setCheckboxState=function(b,c){a.assert(typeof b==="number","Expected to be a number");a.assert(typeof c==="boolean","Expected to be a number");var f,g,e;f=this.gridAdapter.getCheckboxState(b);if(f!==c){g=this._createCheckboxId(b,d.ChecklistDataAdapter._CHECKBOX_COLUMN_INDEX);e=$("#"+g,this._canvas);e.length>0&&e.attr("checked",c);this._setCheckboxStateData(b,c)}};g.prototype._setCheckboxStateData=function(a,b){this.gridAdapter.setCheckboxStateData(a,b)};g.prototype._updateOptions=function(b){var a={canSortBy:false,text:"",width:30,fixed:true};b.columns.splice(d.ChecklistDataAdapter._CHECKBOX_COLUMN_INDEX,0,a)};g.prototype._determineIndentIndex=function(){this._indentIndex=d.ChecklistDataAdapter._CHECKBOX_COLUMN_INDEX+1};g.prototype._createLabel=function(b,c){a.assertParamIsString(b,"controlId");a.assertParamIsString(c,"text");return $("<label/>").attr("For",b).addClass("hidden").text(c)};g.prototype._drawCell=function(o,e,l,p,k,n,m){var f,i,g,j;if(k.index!==d.ChecklistDataAdapter._CHECKBOX_COLUMN_INDEX)return h.prototype._drawCell.call(this,o,e,l,p,k,n,m);f=$(b("div","grid-cell"));f.width(k.width||20);j=this.getColumnValue(e,d.ChecklistDataAdapter._CHECKBOX_COLUMN_INDEX);a.assert(typeof j==="boolean","Checkbox state must be a numeric value");g=this._createCheckboxId(e,d.ChecklistDataAdapter._CHECKBOX_COLUMN_INDEX);i=$("<input type='checkbox' tabindex='-1' id='"+g+"'>").data("checkbox-data-index",e).attr("checked",j);this._bind(i,"click",c(this,this._onCheckboxClicked));f.append(i);f.append(this._createLabel(g,this.getColumnValue(e,this._labelColumnIndex)));return f};g.prototype._onHeaderCheckboxClicked=function(b){var a;a=$(b.currentTarget).is(":checked");this._setHeaderCheckboxState(a)};g.prototype._onCheckboxClicked=function(d){var a=$(d.currentTarget),b,c;b=a.data("checkbox-data-index");c=a.is(":checked");this.setCheckboxState(b,c)};g.prototype._createCheckboxId=function(c,b){a.assert(typeof c==="number","Expected to be a number");a.assert(typeof b==="number","Expected to be a number");return f.StringUtils.format("checkbox-{0}-{1}",c,b)};g.prototype._setHeaderCheckboxState=function(h){var c,e=this._options.columns,f,b,i;for(b=0,i=e.length;b<i;b+=1)if(e[b].index===d.ChecklistDataAdapter._CHECKBOX_COLUMN_INDEX){f=e[b];break}a.assert(typeof f!=="undefined","Expected to find the checkbox column");c=$("#"+g._HEADER_CHECKBOX_ID,this._headerCanvas);a.assert(Boolean(c.length===1),"Expected to find the header checkbox");c.attr("checked",h);f.checked=h};g.prototype._onKeyDown=function(b){a.assertParamIsObject(b,"e");var c=h.prototype._onKeyDown.call(this,b);if(b.keyCode===e.KeyCode.SPACE){this._onSpaceKey(b);c=false}return c};g.prototype._onSpaceKey=function(c){a.assertParamIsObject(c,"e");var b=this.getSelectedDataIndex();b>=0&&this.setCheckboxState(b,!this.gridAdapter.getCheckboxState(b))};return g}(g);i.CheckboxSelectionGrid=k;n.initClassPrototype(k,{_labelColumnIndex:k._DEFAULT_LABEL_COLUMN,_selectAllLabel:null,dataProvider:null,gridAdapter:null});var r=function(b){__extends(a,b);function a(a){b.call(this,a)}a._typeName="tfs.listview";return a}(g);i.ListView=r;h.Enhancement.registerJQueryWidget(r,"listView");$(function(){function a(){var a;a=$(document.body).children(".main-container")[0];function b(){if(a)a.style.overflowX=a.clientWidth!==a.scrollWidth?"scroll":"auto"}$(window).resize(function(a){a.target===window&&b()});b()}$.browser.msie&&a()});n.tfsModuleLoaded("TFS.UI.Controls.Grids",i)});
// SIG // Begin signature block
// SIG // MIIbEQYJKoZIhvcNAQcCoIIbAjCCGv4CAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFCGHABWTkPx8
// SIG // qlBg5RCzvkMMBUVcoIIVgjCCBMMwggOroAMCAQICEzMA
// SIG // AABxsy6Ka4KqH04AAAAAAHEwDQYJKoZIhvcNAQEFBQAw
// SIG // dzELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWlj
// SIG // cm9zb2Z0IFRpbWUtU3RhbXAgUENBMB4XDTE1MDMyMDE3
// SIG // MzIwM1oXDTE2MDYyMDE3MzIwM1owgbMxCzAJBgNVBAYT
// SIG // AlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQH
// SIG // EwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29y
// SIG // cG9yYXRpb24xDTALBgNVBAsTBE1PUFIxJzAlBgNVBAsT
// SIG // Hm5DaXBoZXIgRFNFIEVTTjpCOEVDLTMwQTQtNzE0NDEl
// SIG // MCMGA1UEAxMcTWljcm9zb2Z0IFRpbWUtU3RhbXAgU2Vy
// SIG // dmljZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBAOqRvbKI/RRvITYoA2YzOmYI+1tLpKugKDRKQzII
// SIG // wIblyT3VJbx7PmKH1n3vD3RTo/GRY4h0f+gkzQNQxfHK
// SIG // ABZ7pTmwBhw8RH7568SygbwXI7r9ZTgZhX/KoCn99jrA
// SIG // Cy9o9OA0Tn1vF8Bumar6f2El0SZw0nR932FzXM5UKjlR
// SIG // AzMJ+FCteMeJCLbUhSo/19gfUerv/GhetcHnB2gyjS9y
// SIG // Uf4DMUdRxdLrcgevIJX42mr4d2fkYJpwTKtFy34Ir+WB
// SIG // 1FfPOswTdZ0mzaCiaVC8OoiU37BUON6JOc2GMqWQD36/
// SIG // 7cyUJaZBhmEmx903flwN6BfKN3/oJLZOtPgbI+sCAwEA
// SIG // AaOCAQkwggEFMB0GA1UdDgQWBBT4/SOHBZSAVs0zpUHC
// SIG // bMwINsiyojAfBgNVHSMEGDAWgBQjNPjZUkZwCu1A+3b7
// SIG // syuwwzWzDzBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8v
// SIG // Y3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0
// SIG // cy9NaWNyb3NvZnRUaW1lU3RhbXBQQ0EuY3JsMFgGCCsG
// SIG // AQUFBwEBBEwwSjBIBggrBgEFBQcwAoY8aHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNyb3Nv
// SIG // ZnRUaW1lU3RhbXBQQ0EuY3J0MBMGA1UdJQQMMAoGCCsG
// SIG // AQUFBwMIMA0GCSqGSIb3DQEBBQUAA4IBAQAtBLTKKQtZ
// SIG // /C7qoK9MTmgE+JLtKcJmzGtwyYfovof8XfTdT6Uab3iX
// SIG // rWsFOFFBcp055Bobw21x/HC208y2kFgEKD/WHu+DsxQY
// SIG // DJUL96URE5jGhVZe7jO0DDe1gOr1EmjZLnuGCHI7FHvU
// SIG // 2dAWT8AvCx8tyuUb0K7phLCPC11zuBaBQCNYLOphqv69
// SIG // f9ONWnD8ec1mlmVjtQUSduIqOyvtgqya7CdBp5cOIxaf
// SIG // QchObVMRQATMYJnamOwrrpf74H31uosA9CUXf2J6u1FX
// SIG // wfDwzZwbYXOtlYwrdiKoq3A4tAEofWZCU96f9Ad8WjAO
// SIG // ggNZ9oSGuRUlYrAL0s/x25ZFMIIE7DCCA9SgAwIBAgIT
// SIG // MwAAAQosea7XeXumrAABAAABCjANBgkqhkiG9w0BAQUF
// SIG // ADB5MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGlu
// SIG // Z3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMV
// SIG // TWljcm9zb2Z0IENvcnBvcmF0aW9uMSMwIQYDVQQDExpN
// SIG // aWNyb3NvZnQgQ29kZSBTaWduaW5nIFBDQTAeFw0xNTA2
// SIG // MDQxNzQyNDVaFw0xNjA5MDQxNzQyNDVaMIGDMQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BSMR4wHAYD
// SIG // VQQDExVNaWNyb3NvZnQgQ29ycG9yYXRpb24wggEiMA0G
// SIG // CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCS/G82u+ED
// SIG // uSjWRtGiYbqlRvtjFj4u+UfSx+ztx5mxJlF1vdrMDwYU
// SIG // EaRsGZ7AX01UieRNUNiNzaFhpXcTmhyn7Q1096dWeego
// SIG // 91PSsXpj4PWUl7fs2Uf4bD3zJYizvArFBKeOfIVIdhxh
// SIG // RqoZxHpii8HCNar7WG/FYwuTSTCBG3vff3xPtEdtX3gc
// SIG // r7b3lhNS77nRTTnlc95ITjwUqpcNOcyLUeFc0Tvwjmfq
// SIG // MGCpTVqdQ73bI7rAD9dLEJ2cTfBRooSq5JynPdaj7woY
// SIG // SKj6sU6lmA5Lv/AU8wDIsEjWW/4414kRLQW6QwJPIgCW
// SIG // Ja19NW6EaKsgGDgo/hyiELGlAgMBAAGjggFgMIIBXDAT
// SIG // BgNVHSUEDDAKBggrBgEFBQcDAzAdBgNVHQ4EFgQUif4K
// SIG // MeomzeZtx5GRuZSMohhhNzQwUQYDVR0RBEowSKRGMEQx
// SIG // DTALBgNVBAsTBE1PUFIxMzAxBgNVBAUTKjMxNTk1KzA0
// SIG // MDc5MzUwLTE2ZmEtNGM2MC1iNmJmLTlkMmIxY2QwNTk4
// SIG // NDAfBgNVHSMEGDAWgBTLEejK0rQWWAHJNy4zFha5TJoK
// SIG // HzBWBgNVHR8ETzBNMEugSaBHhkVodHRwOi8vY3JsLm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWND
// SIG // b2RTaWdQQ0FfMDgtMzEtMjAxMC5jcmwwWgYIKwYBBQUH
// SIG // AQEETjBMMEoGCCsGAQUFBzAChj5odHRwOi8vd3d3Lm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY0NvZFNpZ1BD
// SIG // QV8wOC0zMS0yMDEwLmNydDANBgkqhkiG9w0BAQUFAAOC
// SIG // AQEApqhTkd87Af5hXQZa62bwDNj32YTTAFEOENGk0Rco
// SIG // 54wzOCvYQ8YDi3XrM5L0qeJn/QLbpR1OQ0VdG0nj4E8W
// SIG // 8H6P8IgRyoKtpPumqV/1l2DIe8S/fJtp7R+CwfHNjnhL
// SIG // YvXXDRzXUxLWllLvNb0ZjqBAk6EKpS0WnMJGdAjr2/TY
// SIG // pUk2VBIRVQOzexb7R/77aPzARVziPxJ5M6LvgsXeQBkH
// SIG // 7hXFCptZBUGp0JeegZ4DW/xK4xouBaxQRy+M+nnYHiD4
// SIG // BfspaxgU+nIEtwunmmTsEV1PRUmNKRot+9C2CVNfNJTg
// SIG // FsS56nM16Ffv4esWwxjHBrM7z2GE4rZEiZSjhjCCBbww
// SIG // ggOkoAMCAQICCmEzJhoAAAAAADEwDQYJKoZIhvcNAQEF
// SIG // BQAwXzETMBEGCgmSJomT8ixkARkWA2NvbTEZMBcGCgmS
// SIG // JomT8ixkARkWCW1pY3Jvc29mdDEtMCsGA1UEAxMkTWlj
// SIG // cm9zb2Z0IFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5
// SIG // MB4XDTEwMDgzMTIyMTkzMloXDTIwMDgzMTIyMjkzMlow
// SIG // eTELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEjMCEGA1UEAxMaTWlj
// SIG // cm9zb2Z0IENvZGUgU2lnbmluZyBQQ0EwggEiMA0GCSqG
// SIG // SIb3DQEBAQUAA4IBDwAwggEKAoIBAQCycllcGTBkvx2a
// SIG // YCAgQpl2U2w+G9ZvzMvx6mv+lxYQ4N86dIMaty+gMuz/
// SIG // 3sJCTiPVcgDbNVcKicquIEn08GisTUuNpb15S3GbRwfa
// SIG // /SXfnXWIz6pzRH/XgdvzvfI2pMlcRdyvrT3gKGiXGqel
// SIG // cnNW8ReU5P01lHKg1nZfHndFg4U4FtBzWwW6Z1KNpbJp
// SIG // L9oZC/6SdCnidi9U3RQwWfjSjWL9y8lfRjFQuScT5EAw
// SIG // z3IpECgixzdOPaAyPZDNoTgGhVxOVoIoKgUyt0vXT2Pn
// SIG // 0i1i8UU956wIAPZGoZ7RW4wmU+h6qkryRs83PDietHdc
// SIG // pReejcsRj1Y8wawJXwPTAgMBAAGjggFeMIIBWjAPBgNV
// SIG // HRMBAf8EBTADAQH/MB0GA1UdDgQWBBTLEejK0rQWWAHJ
// SIG // Ny4zFha5TJoKHzALBgNVHQ8EBAMCAYYwEgYJKwYBBAGC
// SIG // NxUBBAUCAwEAATAjBgkrBgEEAYI3FQIEFgQU/dExTtMm
// SIG // ipXhmGA7qDFvpjy82C0wGQYJKwYBBAGCNxQCBAweCgBT
// SIG // AHUAYgBDAEEwHwYDVR0jBBgwFoAUDqyCYEBWJ5flJRP8
// SIG // KuEKU5VZ5KQwUAYDVR0fBEkwRzBFoEOgQYY/aHR0cDov
// SIG // L2NybC5taWNyb3NvZnQuY29tL3BraS9jcmwvcHJvZHVj
// SIG // dHMvbWljcm9zb2Z0cm9vdGNlcnQuY3JsMFQGCCsGAQUF
// SIG // BwEBBEgwRjBEBggrBgEFBQcwAoY4aHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNyb3NvZnRS
// SIG // b290Q2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggIBAFk5
// SIG // Pn8mRq/rb0CxMrVq6w4vbqhJ9+tfde1MOy3XQ60L/svp
// SIG // LTGjI8x8UJiAIV2sPS9MuqKoVpzjcLu4tPh5tUly9z7q
// SIG // QX/K4QwXaculnCAt+gtQxFbNLeNK0rxw56gNogOlVuC4
// SIG // iktX8pVCnPHz7+7jhh80PLhWmvBTI4UqpIIck+KUBx3y
// SIG // 4k74jKHK6BOlkU7IG9KPcpUqcW2bGvgc8FPWZ8wi/1wd
// SIG // zaKMvSeyeWNWRKJRzfnpo1hW3ZsCRUQvX/TartSCMm78
// SIG // pJUT5Otp56miLL7IKxAOZY6Z2/Wi+hImCWU4lPF6H0q7
// SIG // 0eFW6NB4lhhcyTUWX92THUmOLb6tNEQc7hAVGgBd3TVb
// SIG // Ic6YxwnuhQ6MT20OE049fClInHLR82zKwexwo1eSV32U
// SIG // jaAbSANa98+jZwp0pTbtLS8XyOZyNxL0b7E8Z4L5UrKN
// SIG // MxZlHg6K3RDeZPRvzkbU0xfpecQEtNP7LN8fip6sCvsT
// SIG // J0Ct5PnhqX9GuwdgR2VgQE6wQuxO7bN2edgKNAltHIAx
// SIG // H+IOVN3lofvlRxCtZJj/UBYufL8FIXrilUEnacOTj5XJ
// SIG // jdibIa4NXJzwoq6GaIMMai27dmsAHZat8hZ79haDJLmI
// SIG // z2qoRzEvmtzjcT3XAH5iR9HOiMm4GPoOco3Boz2vAkBq
// SIG // /2mbluIQqBC0N1AI1sM9MIIGBzCCA++gAwIBAgIKYRZo
// SIG // NAAAAAAAHDANBgkqhkiG9w0BAQUFADBfMRMwEQYKCZIm
// SIG // iZPyLGQBGRYDY29tMRkwFwYKCZImiZPyLGQBGRYJbWlj
// SIG // cm9zb2Z0MS0wKwYDVQQDEyRNaWNyb3NvZnQgUm9vdCBD
// SIG // ZXJ0aWZpY2F0ZSBBdXRob3JpdHkwHhcNMDcwNDAzMTI1
// SIG // MzA5WhcNMjEwNDAzMTMwMzA5WjB3MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSEwHwYDVQQDExhNaWNyb3NvZnQgVGltZS1T
// SIG // dGFtcCBQQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQCfoWyx39tIkip8ay4Z4b3i48WZUSNQrc7d
// SIG // GE4kD+7Rp9FMrXQwIBHrB9VUlRVJlBtCkq6YXDAm2gBr
// SIG // 6Hu97IkHD/cOBJjwicwfyzMkh53y9GccLPx754gd6udO
// SIG // o6HBI1PKjfpFzwnQXq/QsEIEovmmbJNn1yjcRlOwhtDl
// SIG // KEYuJ6yGT1VSDOQDLPtqkJAwbofzWTCd+n7Wl7PoIZd+
// SIG // +NIT8wi3U21StEWQn0gASkdmEScpZqiX5NMGgUqi+YSn
// SIG // EUcUCYKfhO1VeP4Bmh1QCIUAEDBG7bfeI0a7xC1Un68e
// SIG // eEExd8yb3zuDk6FhArUdDbH895uyAc4iS1T/+QXDwiAL
// SIG // AgMBAAGjggGrMIIBpzAPBgNVHRMBAf8EBTADAQH/MB0G
// SIG // A1UdDgQWBBQjNPjZUkZwCu1A+3b7syuwwzWzDzALBgNV
// SIG // HQ8EBAMCAYYwEAYJKwYBBAGCNxUBBAMCAQAwgZgGA1Ud
// SIG // IwSBkDCBjYAUDqyCYEBWJ5flJRP8KuEKU5VZ5KShY6Rh
// SIG // MF8xEzARBgoJkiaJk/IsZAEZFgNjb20xGTAXBgoJkiaJ
// SIG // k/IsZAEZFgltaWNyb3NvZnQxLTArBgNVBAMTJE1pY3Jv
// SIG // c29mdCBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eYIQ
// SIG // ea0WoUqgpa1Mc1j0BxMuZTBQBgNVHR8ESTBHMEWgQ6BB
// SIG // hj9odHRwOi8vY3JsLm1pY3Jvc29mdC5jb20vcGtpL2Ny
// SIG // bC9wcm9kdWN0cy9taWNyb3NvZnRyb290Y2VydC5jcmww
// SIG // VAYIKwYBBQUHAQEESDBGMEQGCCsGAQUFBzAChjhodHRw
// SIG // Oi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01p
// SIG // Y3Jvc29mdFJvb3RDZXJ0LmNydDATBgNVHSUEDDAKBggr
// SIG // BgEFBQcDCDANBgkqhkiG9w0BAQUFAAOCAgEAEJeKw1wD
// SIG // RDbd6bStd9vOeVFNAbEudHFbbQwTq86+e4+4LtQSooxt
// SIG // YrhXAstOIBNQmd16QOJXu69YmhzhHQGGrLt48ovQ7DsB
// SIG // 7uK+jwoFyI1I4vBTFd1Pq5Lk541q1YDB5pTyBi+FA+mR
// SIG // KiQicPv2/OR4mS4N9wficLwYTp2OawpylbihOZxnLcVR
// SIG // DupiXD8WmIsgP+IHGjL5zDFKdjE9K3ILyOpwPf+FChPf
// SIG // wgphjvDXuBfrTot/xTUrXqO/67x9C0J71FNyIe4wyrt4
// SIG // ZVxbARcKFA7S2hSY9Ty5ZlizLS/n+YWGzFFW6J1wlGys
// SIG // OUzU9nm/qhh6YinvopspNAZ3GmLJPR5tH4LwC8csu89D
// SIG // s+X57H2146SodDW4TsVxIxImdgs8UoxxWkZDFLyzs7BN
// SIG // Z8ifQv+AeSGAnhUwZuhCEl4ayJ4iIdBD6Svpu/RIzCzU
// SIG // 2DKATCYqSCRfWupW76bemZ3KOm+9gSd0BhHudiG/m4LB
// SIG // J1S2sWo9iaF2YbRuoROmv6pH8BJv/YoybLL+31HIjCPJ
// SIG // Zr2dHYcSZAI9La9Zj7jkIeW1sMpjtHhUBdRBLlCslLCl
// SIG // eKuzoJZ1GtmShxN1Ii8yqAhuoFuMJb+g74TKIdbrHk/J
// SIG // mu5J4PcBZW+JC33Iacjmbuqnl84xKf8OxVtc2E0bodj6
// SIG // L54/LlUWa8kTo/0xggT7MIIE9wIBATCBkDB5MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQQITMwAAAQosea7XeXumrAAB
// SIG // AAABCjAJBgUrDgMCGgUAoIIBEzAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQUpo2/6yWb
// SIG // iyKtOkatp3MKKrQkfUUwgbIGCisGAQQBgjcCAQwxgaMw
// SIG // gaCggYWAgYIAVABGAFMALgBVAEkALgBDAG8AbgB0AHIA
// SIG // bwBsAHMALgBHAHIAaQBkAHMALgBtAGkAbgBfADcANgAy
// SIG // AGQAMwAyAGEAZQAtAGQAYgAxAGIALQA0AGYAYwA1AC0A
// SIG // YgA3ADEAYQAtADEAOQBlADIAMwA5ADYAMgAwADcAMwA0
// SIG // AC4AagBzoRaAFGh0dHA6Ly9taWNyb3NvZnQuY29tMA0G
// SIG // CSqGSIb3DQEBAQUABIIBACqmRsjnsQq7r6JZBTcAh5FC
// SIG // EZeTEiAGzZY2cmvvM9hz84L0K0mPvBmGe44qV0tYTC5R
// SIG // bJaD3rfQCO8Kl+ok6zs1lR0xVPg0tV7hJ9hww1/+cXoS
// SIG // wfpu7Q+Ff1O7TLKXLPMkj9Ope9YiMrp7/x2EvRVNw8p8
// SIG // eSjjC/8qXgWYqLlBf7X5Ve1ci6spJ+4N9EIlpU6dyOf+
// SIG // 9U13snCoPlezl+7NAkxqf263ykmMw8OvWe+I8NXVEGUb
// SIG // ZzbDjgYzzDze9elPfLTbPwIV5U6GbdkuDYt4rPuvYNJn
// SIG // FBAhNsv58rXy9onfWYJ/EJN9Mh9Z4npuUYFT3LIp4Lyb
// SIG // rrD1RakNeByhggIoMIICJAYJKoZIhvcNAQkGMYICFTCC
// SIG // AhECAQEwgY4wdzELMAkGA1UEBhMCVVMxEzARBgNVBAgT
// SIG // Cldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAc
// SIG // BgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEhMB8G
// SIG // A1UEAxMYTWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBAhMz
// SIG // AAAAcbMuimuCqh9OAAAAAABxMAkGBSsOAwIaBQCgXTAY
// SIG // BgkqhkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwGCSqGSIb3
// SIG // DQEJBTEPFw0xNTA2MjkwNDM0MzBaMCMGCSqGSIb3DQEJ
// SIG // BDEWBBSS430/3Z2jH9B4TC7XxrFoX02G7jANBgkqhkiG
// SIG // 9w0BAQUFAASCAQDUIJEZ04zvOrFSdvERvD9V/iKOK0uF
// SIG // YBWT6TgBDFMqTF0GcHd1tr+xEG75wQjU4dtKiMSWzTT8
// SIG // jBxZDDXNysA6fpPtLPbKc14AaVld0cSp260Tg0TWi931
// SIG // u3Pm4mzBDzgY6IbhFgkr7CxOg9kufWEsgA8HdFEuJ/kq
// SIG // l1BA6M7pjyqChohtSJ7n7OmGO1LP2uVDw8nQ9ieZXK7E
// SIG // acU3gyaC+h4nxW+4ALO3O1de6G+3q/DXplv7ZWbB7fSV
// SIG // TJ0dh7sCC+y962RqpfvyUI+1wPB+J0fn83UYKp6MIT39
// SIG // c0NasNrEv2JmBWh2iIVyqrWnu0Ndn9PKuq2R/++SV/QK
// SIG // CUhD
// SIG // End signature block
